<?php

/**
 * renders certificate
 * checks if user is it's owner
 */
class InvoiceAction extends CAction
{
	public function run($id)
	{
		$id = filter_var($id, FILTER_VALIDATE_INT);

		$faktura = Faktury::model()->with('kontrahent', 'firma.biura.budynek')->findByPk($id);

		if (empty($faktura))
			throw new CHttpException(404, 'Nie ma podanej faktury.');

		switch (Yii::app()->user->role)
		{
			case 'admin': //zawsze dostęp
				break;
			case 'student': //czy uczeń jest właścicelem firmy
				if (empty(Yii::app()->user->id_firmy) || $faktura->idFirmy != Yii::app()->user->id_firmy)
					throw new CHttpException(404, 'Brak uprawnień');
				break;
			case 'teacher': //czy nauczyciel uczy klasę firmy
				$rec = AdminKlasy::model()->find('"t"."idAdmina" = :teacherId AND "t"."idKlasy" = :classId', array(
					':teacherId' => Yii::app()->user->id,
					':classId' => $faktura->firma->idKlasy
				));
				if (empty($rec))
					throw new CHttpException(404, 'Brak uprawnień');
				break;
			default:
				throw new CHttpException(404, 'Brak uprawnień');
		}

		require_once('tcpdf/tcpdf.php');

		$pdf = new TCPDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'utf-8', false);

		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor('imaginalis.pl');
		$pdf->SetTitle('Faktura ' . $faktura->nrFaktury);
		$pdf->SetSubject('Faktura ' . $faktura->nrFaktury);
		$pdf->SetKeywords('faktura, vat, ');

		$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		$pdf->SetFont('helvetica', 'BI', 15, '', 'false');

		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(0);
		$pdf->SetFooterMargin(0);

		$pdf->setPrintFooter(false);
		$pdf->setPrintHeader(false);

		$pdf->SetAutoPageBreak(FALSE);

		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
				require_once(dirname(__FILE__).'/lang/eng.php');
				$pdf->setLanguageArray($l);
		}

		$pdf->AddPage();
		$pdf->SetFont('dejavusans', '', 8);

		$pdf->writeHTML($this->getController()->renderPartial(
			'application.controllers.actions.views.invoice', array('faktura' => $faktura), true),
			true, false, true, false, '');

		$pdf->Output('Faktura ' . $faktura->nrFaktury . '.pdf', 'I');
	}
}
